/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.items;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2338;
import net.minecraft.class_2401;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4538;
import wile.redstonepen.blocks.ControlBox;
import wile.redstonepen.libmc.Auxiliaries;
import wile.redstonepen.libmc.Overlay;
import wile.redstonepen.libmc.StandardItems;

public class RemoteItem
extends StandardItems.BaseItem {
    public RemoteItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 ctx, List<class_2561> tooltip, class_1836 flag) {
        RemoteData data = this.getRemoteData(stack).orElse(null);
        if (data != null) {
            tooltip.add((class_2561)Auxiliaries.localizable("item.redstonepen.remote.tooltip.linkedto", data.pos.method_10263(), data.pos.method_10264(), data.pos.method_10260(), class_2561.method_43471((String)data.name)));
        } else {
            tooltip.add((class_2561)Auxiliaries.localizable("item.redstonepen.remote.tooltip.notlinked"));
        }
        Auxiliaries.Tooltip.addInformation(stack, ctx, tooltip, flag, true);
    }

    @Override
    public boolean doesSneakBypassUse(class_1799 stack, class_4538 world, class_2338 pos, class_1657 player) {
        return false;
    }

    public boolean method_31567(class_1799 stack) {
        return false;
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        class_1799 stack = player.method_6047().method_7909() instanceof RemoteItem ? player.method_6047() : player.method_6079();
        this.attack(stack, pos, player);
        return false;
    }

    @Override
    public boolean onBlockStartBreak(class_1799 stack, class_2338 pos, class_1657 player) {
        this.attack(stack, pos, player);
        return false;
    }

    public float method_58404(class_1799 stack, class_2680 state) {
        return 10000.0f;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (world.field_9236) {
            return class_1271.method_22427((Object)player.method_5998(hand));
        }
        this.onTriggerRemoteLink((class_3218)world, (class_3222)player, player.method_5998(hand));
        return class_1271.method_22431((Object)player.method_5998(hand));
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        if (context.method_8045().field_9236) {
            return class_1269.field_5812;
        }
        this.onTriggerRemoteLink((class_3218)context.method_8045(), (class_3222)context.method_8036(), stack);
        return class_1269.field_21466;
    }

    private void onTriggerRemoteLink(class_3218 world, class_3222 player, class_1799 stack) {
        RemoteData data = this.getRemoteData(stack).orElse(null);
        if (data == null) {
            return;
        }
        BiConsumer<class_3414, Float> sound = (event, pitch) -> world.method_8396(null, player.method_24515(), event, class_3419.field_15248, 0.25f, pitch.floatValue());
        Runnable fail = () -> sound.accept(class_3417.field_14797, Float.valueOf(1.8f));
        class_2338 pos = data.pos;
        if (!world.method_8477(pos)) {
            fail.run();
            return;
        }
        class_2680 state = world.method_8320(pos);
        if (!state.method_28498((class_2769)class_2741.field_12484)) {
            fail.run();
            return;
        }
        class_2248 block = state.method_26204();
        boolean powered = (Boolean)state.method_11654((class_2769)class_2741.field_12484);
        if (block instanceof class_2269) {
            class_2269 button = (class_2269)block;
            if (powered) {
                return;
            }
            button.method_21845(state, (class_1937)world, pos, null);
            sound.accept(class_3417.field_14791, Float.valueOf(1.7f));
        } else if (block instanceof class_2401) {
            class_2401 lever = (class_2401)block;
            lever.method_21846(state, (class_1937)world, pos, null);
            sound.accept(class_3417.field_14962, Float.valueOf(powered ? 1.3f : 1.5f));
        } else if (block instanceof ControlBox.ControlBoxBlock) {
            class_2586 te = world.method_8321(pos);
            if (!(te instanceof ControlBox.ControlBoxBlockEntity)) {
                fail.run();
                return;
            }
            ControlBox.ControlBoxBlockEntity rlc = (ControlBox.ControlBoxBlockEntity)te;
            rlc.setEnabled(!rlc.getEnabled());
            sound.accept(class_3417.field_14962, Float.valueOf(rlc.getEnabled() ? 1.5f : 1.3f));
        } else {
            fail.run();
        }
    }

    private Optional<RemoteData> getRemoteData(class_1799 stack) {
        class_2487 nbt = Auxiliaries.getItemStackNbt(stack, "remote");
        if (nbt == null || !nbt.method_10573("pos", 99) || !nbt.method_10573("name", 8)) {
            return Optional.empty();
        }
        return Optional.of(new RemoteData(class_2338.method_10092((long)nbt.method_10537("pos")), nbt.method_10558("name")));
    }

    private void setRemoteData(class_1799 stack, class_2338 pos, String name) {
        class_2487 nbt = new class_2487();
        nbt.method_10544("pos", pos.method_10063());
        nbt.method_10582("name", name);
        Auxiliaries.setItemStackNbt(stack, "remote", nbt);
    }

    private boolean attack(class_1799 stack, class_2338 pos, class_1657 player) {
        if (!(stack.method_7909() instanceof RemoteItem)) {
            return false;
        }
        if (!(player instanceof class_3222)) {
            return false;
        }
        class_3222 splayer = (class_3222)player;
        class_2680 state = splayer.method_51469().method_8320(pos);
        if (state.method_26204() instanceof class_2401 || state.method_26204() instanceof class_2269 || state.method_26204() instanceof ControlBox.ControlBoxBlock) {
            String name = state.method_26204().method_9539();
            this.setRemoteData(stack, pos, name);
            Overlay.show(splayer, (class_2561)Auxiliaries.localizable("overlay.remote_saved", pos.method_10263(), pos.method_10264(), pos.method_10260(), class_2561.method_43471((String)name)), 1500);
        }
        return true;
    }

    private record RemoteData(class_2338 pos, String name) {
    }
}

